using System;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Summary description for BaseAdminFormControl.
	/// </summary>
	public class BaseAdminFormControl : System.Windows.Forms.UserControl
	{
		private System.Windows.Forms.ToolTip ttMainToolTip;
		private System.ComponentModel.IContainer components;

		private readonly CountingTrigger _dataLoadToken;

		/// <summary>
		/// erpMainProvider
		/// </summary>
		protected gov.va.med.vbecs.GUI.controls.VbecsErrorProvider erpMainProvider; // **** 508 Compliance ***

		/// <summary>
		/// _validator
		/// </summary>
		protected GuiValidator _validator;

		/// <summary>
		/// Constructor
		/// </summary>
		public BaseAdminFormControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			_validator = new GuiValidator( erpMainProvider );
			_dataLoadToken = new CountingTrigger();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(BaseAdminFormControl));
			this.erpMainProvider = new gov.va.med.vbecs.GUI.controls.VbecsErrorProvider(); // **** 508 Compliance ***
			this.ttMainToolTip = new System.Windows.Forms.ToolTip(this.components);
			// 
			// erpMainProvider
			// 
			this.erpMainProvider.ContainerControl = this;
			this.erpMainProvider.Icon = ((System.Drawing.Icon)(resources.GetObject("erpMainProvider.Icon")));
			// 
			// ttMainToolTip
			// 
			this.ttMainToolTip.ShowAlways = true;
			// 
			// BaseAdminFormControl
			// 
			this.Name = "BaseAdminFormControl";
			this.Size = new System.Drawing.Size(216, 152);

		}
		#endregion

		/// <summary>
		/// SetToolTip
		/// </summary>
		/// <param name="control"></param>
		/// <param name="toolTipText"></param>
		protected void SetToolTip( Control control, string toolTipText )
		{
			if( control == null )
				throw( new ArgumentNullException( "control" ) );

			if( toolTipText == null )
				throw( new ArgumentNullException( "toolTipText" ) );

			ttMainToolTip.SetToolTip( control, toolTipText );
		}

		/// <summary>
		/// SetToolTip
		/// </summary>
		/// <param name="control"></param>
		/// <param name="toolTipText"></param>
		protected void SetToolTip( Control control, StrRes.StringResourceItem toolTipText )
		{
			SetToolTip( control, toolTipText.ResString ); // arguments are verified by callee
		}

		/// <summary>
		/// ClearToolTip
		/// </summary>
		/// <param name="control"></param>
		protected void ClearToolTip( Control control )
		{
			if( control == null )
				throw( new ArgumentNullException( "control" ) );

			ttMainToolTip.SetToolTip( control, null );
		}

		/// <summary>
		/// SetToolTip
		/// </summary>
		/// <param name="button"></param>
		/// <param name="toolTipItem"></param>
		protected void SetToolTip( VbecsButton button, StrRes.StringResourceItem toolTipItem )
		{			
			SetToolTip( button, toolTipItem.ResString ); 
		}

		/// <summary>
		/// SetToolTip
		/// </summary>
		/// <param name="button"></param>
		/// <param name="toolTipText"></param>
		protected void SetToolTip( VbecsButton button, string toolTipText )
		{
			if( button == null )
				throw( new ArgumentNullException( "button" ) );

			if( toolTipText == null )
				throw( new ArgumentNullException( "toolTipText" ) );

			button.SetToolTip( toolTipText );
		}

		/// <summary>
		/// ClearToolTip
		/// </summary>
		/// <param name="button"></param>
		protected void ClearToolTip( VbecsButton button )
		{
			if( button == null )
				throw( new ArgumentNullException( "button" ) );

			button.SetToolTip( null );
		}

		/// <summary>
		/// Get DataLoadMode
		/// </summary>
		protected CountingTrigger DataLoadMode
		{
			get
			{
				return _dataLoadToken;
			}
		}

		/// <summary>
		/// ResultAfterHostRefresh
		/// </summary>
		/// <param name="result"></param>
		/// <returns></returns>
		protected virtual bool ResultAfterHostRefresh( bool result )
		{
			this.Refresh(); // to prevent user from observing leftovers of the dialog during lengthy data save operation.
			return result;
		}

		/// <summary>
		/// UpdateOnFormClearButton
		/// </summary>
		/// <param name="btnClear"></param>
		/// <param name="isDirty"></param>
		protected static void UpdateOnFormClearButton( VbecsButton btnClear, bool isDirty )
		{
			btnClear.EnabledButton = isDirty;
			btnClear.SetToolTip( ( isDirty ? StrRes.Tooltips.Common.ClearChangesAndResetScreen() : StrRes.Tooltips.Common.DataWasNotChanged() ).ResString );
		}
	}
}
